class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Hi Def Digest Blu Ray Reviews'
    oldest_article = 30
    max_articles_per_feed = 200
    use_embedded_content  = False
    no_stylesheets = True
    encoding              = 'utf8'

    remove_javascript     = True
    extra_css = '''
        h2{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    keep_only_tags = [dict(name='div',attrs={'id':['r_inner_r','news']})]
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['','']}),
                   dict(name='div', attrs={'id':['recent','stars_menu',]}),
                   dict(name='ul', attrs={'class':['mod']}),
                   dict(name='ul', attrs={'id':['product_info_list']}),
                   dict(name='ol', attrs={'id':['']}),
                   dict(name='span', attrs={'class':['']}),
                   dict(name='div', attrs={'style':'float:right'}),
                   dict(name=['img','iframe','table','cite','dl','br','h3']),]

    feeds          = [(u'Blu Ray Reviews', u'http://feeds.feedburner.com/HDDblurayreviews'), 
                          (u'Blu Ray News', u'http://feeds.feedburner.com/highdefdigestbluraynews')
                          ]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		
    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds